// Copyright (C) 2023 Allen Li
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package udpapi

import "sync"

type syncVar[T any] struct {
	val T
	mu  sync.Mutex
}

func (s *syncVar[T]) get() T {
	s.mu.Lock()
	v := s.val
	s.mu.Unlock()
	return v
}

func (s *syncVar[T]) set(v T) {
	s.mu.Lock()
	s.val = v
	s.mu.Unlock()
}
