// Copyright (C) 2018  Allen Li
//
// This file is part of Animanager.
//
// Animanager is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Animanager is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Animanager.  If not, see <http://www.gnu.org/licenses/>.

package cmd

import (
	"context"
	"flag"
	"fmt"
	"strconv"

	"go.felesatra.moe/animanager/internal/config"
	"go.felesatra.moe/animanager/internal/database"
	"go.felesatra.moe/animanager/internal/query"
)

type Unregister struct {
	watched bool
}

func (*Unregister) Name() string     { return "unregister" }
func (*Unregister) Synopsis() string { return "Unregister an anime." }
func (*Unregister) Usage() string {
	return `Usage: unregister aid...
       unregister -watched [aids...]
Unregister an anime.
`
}

func (c *Unregister) SetFlags(f *flag.FlagSet) {
	f.BoolVar(&c.watched, "watched", false, "Unregister watched anime")
}

func (c *Unregister) Run(ctx context.Context, f *flag.FlagSet, cfg config.Config) error {
	if f.NArg() < 1 && !c.watched {
		return usageError{"no anime specified"}
	}
	aids := make([]int, f.NArg())
	for _, s := range f.Args() {
		aid, err := strconv.Atoi(s)
		if err != nil {
			return fmt.Errorf("invalid AID %v: %v", aid, err)
		}
		aids = append(aids, aid)
	}

	db, err := database.Open(ctx, cfg.DBPath)
	if err != nil {
		return err
	}
	defer db.Close()
	if c.watched && false {
		watching, err := query.GetAllWatching(db)
		if err != nil {
			return err
		}
		watchingMap := make(map[int]bool)
		for _, w := range watching {
			watchingMap[w.AID] = true
		}

		watched, err := query.GetWatchedAnime(db)
		if err != nil {
			return err
		}
		for _, a := range watched {
			if watchingMap[a.AID] {
				aids = append(aids, a.AID)
			}
		}
	}
	for _, aid := range aids {
		fmt.Println(aid)
		if err := query.DeleteWatching(db, aid); err != nil {
			return err
		}
	}
	return nil
}
