// Copyright (C) 2018  Allen Li
//
// This file is part of Animanager.
//
// Animanager is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Animanager is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Animanager.  If not, see <http://www.gnu.org/licenses/>.

package migrate

import (
	"context"
	"database/sql"
	"fmt"
)

func migrate5(ctx context.Context, d *sql.DB) error {
	c, err := d.Conn(ctx)
	if err != nil {
		return err
	}
	defer c.Close()

	_, err = c.ExecContext(ctx, "PRAGMA foreign_keys = 0")
	if err != nil {
		return err
	}
	defer c.ExecContext(ctx, "PRAGMA foreign_keys = 1")

	t, err := c.BeginTx(ctx, nil)
	if err != nil {
		return err
	}
	defer t.Rollback()
	_, err = t.Exec(`
CREATE TABLE watching_new (
    aid INTEGER,
    regexp TEXT NOT NULL,
    offset INTEGER NOT NULL DEFAULT 0,
    PRIMARY KEY (aid),
    FOREIGN KEY (aid) REFERENCES anime (aid)
	ON DELETE CASCADE ON UPDATE CASCADE
)`)
	if err != nil {
		return fmt.Errorf("CREATE TABLE watching_new: %s", err)
	}
	_, err = t.Exec(`
INSERT INTO watching_new
(aid, regexp, offset)
SELECT aid, regexp, 0
FROM watching`)
	if err != nil {
		return fmt.Errorf("INSERT INTO watching_new: %s", err)
	}
	_, err = t.Exec("DROP TABLE watching")
	if err != nil {
		return fmt.Errorf("DROP TABLE watching: %s", err)
	}
	_, err = t.Exec("ALTER TABLE watching_new RENAME TO watching")
	if err != nil {
		return fmt.Errorf("ALTER TABLE watching_new: %s", err)
	}
	return t.Commit()
}
