// Copyright (C) 2018 Allen Li
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package dlsite

import (
	"fmt"
	"os"
	"path/filepath"
	"reflect"
	"testing"

	"github.com/google/go-cmp/cmp"
	"go.felesatra.moe/dlsite/v2/codes"
)

func testdataPath(p string, c codes.RJCode) string {
	return filepath.Join("testdata", p, fmt.Sprintf("%s.html", c))
}

func TestParseWorkWithSeries(t *testing.T) {
	t.Parallel()
	c := "RJ189758"
	want := &Work{
		Code:        codes.RJCode(c),
		Title:       "意地悪な機械人形に完全支配される音声 地獄級射精禁止オナニーサポート4 ヘルエグゼキューション",
		Circle:      "B-bishop",
		Series:      "地獄級オナニーサポート",
		Seiyuu:      []string{"ゅかにゃん", "柚凪", "井上果林", "大山チロル", "西浦のどか"},
		WorkFormats: []string{"ボイス・ASMR"},
		Description: "皆様、こんにちは。サークルB-bishopのpawnlank7と申します。\n今作は、地獄級に激しいオナニーサポート作品第4弾です。\n\n機械人形の『シコシコ』というボイスにあわせてオナニーをすることになり、全てを機械人形に支配されます。\nシコシコの声はセリフとは別で流れますので、言葉責めも絶え間なくお楽しみいただけます。\n\n今作では機械人形に実験と称した地獄を味わわされます。\n『ヘルエグゼキューション』は地獄の執行を意味します。\n\nなお、今作では終盤に複数の女性が登場し、オナニーを見学されるシーンがございます。\nモードによっての難易度に大きな差を設けてありますので、お好みでご試聴くださいませ。\n特にヘルモードでは極めて厳しい内容になっております。\n\n☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆3種類の難易度設定☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆\n\n本作品では、ハードモード、ベリーハードモード、ヘルモードのレベルをご用意しております。\nこれはオナニーパートのトラック数の違いです。\nトラックが進むにつれて段階的に厳しくなりますので、軽い難易度のものほど後半のトラックは削除されております。\n\n●ハードモード\n基本的なプレイが中心のベーシックな内容ですが、射精を強く禁止され、言葉責めも多量となっております。\nシーン08,09を削除\n\n●ベリーハードモード\nさらに視聴者を追い込むトラックが追加されており、内容はとても過酷です。\nシーン10を削除\n\n●ヘルモード\nすべてのシナリオをご堪能いただけますが、大変厳しい内容で、極めて残酷な内容となっております。\nシーン11は特別仕様\n\n重複するシナリオはありますが、ハードモードから徐々に慣らしていくことをオススメいたします。\n\n特にヘルモードは、機械人形は手加減なしの実験を執行するので、容赦は一切ありません。\n\n詳しくは00注意事項をご視聴下さい。\n\n\n☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆収録シーン&難易度☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆\n\n■00\u3000注意事項\n免責事項や説明。\n\n■01\u3000プロローグ\nオナニーサポートについての説明。\n\n■02\u3000実験準備\u3000\u3000★☆☆☆☆☆☆☆☆☆\n勃起の強制を行います。\n耳元で執拗に唾液の淫らな音を流し込みます。\n\n■03\u3000我慢実験\u3000\u3000★★☆☆☆☆☆☆☆☆\n扱きたい気持ちへの我慢を実験します。\nじっくり嬲るようなスピードでのオナニーを強制します。\n\n■04\u3000性交実験\u3000\u3000★★★☆☆☆☆☆☆☆\n女性との性行為で興奮するかを実験します。\n本格的に扱かせ、ペニスへ負荷をかけていきます。\n\n■05\u3000水音実験\u3000\u3000★★★★☆☆☆☆☆☆\nフェラチオの真似で興奮するかを実験します。\n水音に連動した激しいオナニーで責め立てます。\n\n■06\u3000羞恥実験\u3000\u3000★★★★★☆☆☆☆☆\n恥ずかしい行為で興奮するかを実験します。\n卑猥で情けない言葉を連呼させながらいたぶります。\n\n■07\u3000罵倒実験\u3000\u3000★★★★★★☆☆☆☆\n見下したような罵倒で興奮するかを実験します。\n感情もなく厳しい言葉で激しく追い打ちをかけます。\n\n■08\u3000耐久実験\u3000\u3000★★★★★★★★☆☆\n射精させるつもりで行う追加実験です。\n延々と長時間扱かせ、ペニスを狂わせます。\n(ベリーハードモード、ヘルモードのみ)\n\n■09\u3000絶望実験\u3000\u3000★★★★★★★★☆☆\n射精させるつもりで行う追加実験です。\n何度も最高速で扱かせ、ペニスを射精させようとします。\n(ベリーハードモード、ヘルモードのみ)\n\n■10\u3000最終確認\u3000\u3000★★★★★★★★★★\n極めて絶望的な執行を行います。\n内容はご自身でお確かめくださいませ。\n女性1、2が登場します。\n(ヘルモードのみ)\n\n■11\u3000射精許可\u3000\u3000測定不能\n内容はご自身でお確かめくださいませ。\n女性1、2、3、4が登場します。\n(ヘルモードのみ特別仕様)\n\n\n視聴時間は、\n●ハードモード\u3000\u3000\u3000\u3000: 63:15\n●ベリーハードモード\u3000: 75:45\n●ヘルモード\u3000\u3000\u3000\u3000\u3000:107:15\n(いずれも『00注意事項』の時間は含まない)\nとなっております。\n\n\n体験版には、\n00注意事項\n01プロローグ\n作中シーンの一部を3つ\nを収録。\n\n\n声優\n機械人形:ゅかにゃん様\n女性1:柚凪様\n女性2:井上果林様\n女性3:大山チロル様\n女性4:西浦のどか様\n\nイラスト\nHobby様\n\n本作品の販売\nB-bishop http://pawnlank7.blog.fc2.com",
	}
	testParseWork(t, c, "work", want)
}

func TestParseWorkWithoutSeries(t *testing.T) {
	t.Parallel()
	c := "RJ173248"
	want := &Work{
		Code:        codes.RJCode(c),
		Title:       "搾精天使ピュアミルク 背後からバイノーラルでいじめられる音声",
		Circle:      "B-bishop",
		Seiyuu:      []string{"餅よもぎ", "七海うと"},
		WorkFormats: []string{"ボイス・ASMR"},
		Description: "皆様、こんにちは。サークルB-bishopのpawnlank7と申します。\n\n今作は、バイノーラル収録作品となります。\n\n背後から抱きかかえられて囁かれる表現にこだわりました。\n左に右に、近くと遠くで、その変化をお楽しみください。\nとことんまで寸止めされ、焦らされ、馬鹿にされ、いじめられましょう。\n\nSEなし版あり\n\n☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆収録トラック☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆☆\n\n■1.プロローグ\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u300009:39\n貴方がえっちな音声を聞いているところに現れたピュアミルク…。\n彼女はザーメンミルクを貴方に捧げるようにお願いする。\n生意気な彼女に反抗的な貴方、しかし、天使の唾液であっという間に…。\n\n■2.手コキ編\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u300025:08\n背後から抱きかかえられながらの手コキです。\n媚薬効果のある天使の唾液をたっぷり塗りこまれながらのスロー手コキをされます。\n\n■3.足コキ編\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u300014:54\n背後からホールドされながらの足コキです。\n情けなくも足裏で挟み込まれながら、たっぷり可愛がられます。\n\n■4.○○コキ編\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u300024:55\n背後から拘束されて股を強制的に開かされながらの○○コキです。\n搾精天使のマジカルアイテムで一撃で射精まで追い込まれます。\n\n■5.エピローグ\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u300001:47\nザーメンミルクを回収し終わったピュアミルクからのお言葉です。\n\n■おまけ\u3000冒頭えっちボイス\u3000\u3000\u3000\u300005:10\n冒頭で流れるえっちな音声を全編です。\n\n■おまけ\u3000両耳耳舐め\u3000\u3000\u3000\u3000\u3000\u3000\u300000:48\u3000\u3000\u3000\u3000\u3000\n両方の耳を舐め続ける音声です。\nループ再生に対応しています。\n\n\n合計\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u300082:21\n\n\n\n声優\n餅よもぎ様\n七海うと様\n\nイラスト\nふれいむタン様\n\n効果音\nシロクマの嫁様\n\n\n\n本作品の販売\nB-bishop http://pawnlank7.blog.fc2.com/",
	}
	testParseWork(t, c, "work", want)
}

func TestParseWorkWithTracklist(t *testing.T) {
	t.Parallel()
	c := "RJ126928"
	want := &Work{
		Code:        codes.RJCode(c),
		Title:       "まじこスハロウィン -可愛い彼女は吸血鬼!? 妖しく光る魅了の魔眼の巻-",
		Circle:      "クッキーボイス",
		Series:      "ハロウィンパーティー",
		Seiyuu:      []string{"分倍河原シホ"},
		WorkFormats: []string{"ボイス・ASMR"},
		Description: "☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆\n\n月の魔力の影響を色濃く見受けられるこの街で\u3000不定期に開催される『7日間ハロウィン』\n\nそして\u3000その期間中にだけ出回る\u3000”魔法の仮装衣装”\u3000通称『まじこス』\n\n\u3000\u3000\u3000『魔女が仕立ててるんだって』\n\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000『一晩だけ本物の魔物になっちゃうの』\n\u3000\u3000\u3000\u3000\u3000\u3000\u3000『着ると幸運が訪れるらしいよ』\n\n\u3000\u3000\u3000\u3000\u3000\u3000『だけど、お菓子がもらえないと\u3000えっちな呪いにかかっちゃうんだよ』\n\n\u3000\u3000\u3000『ほんと?\u3000なんだか怖い……』\n\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000『んふふ\u3000それがいいんじゃない』\n\n☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆\n\n\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000今宵もまた\u3000楽しい楽しいハロウィーン\n\n\u3000\u3000\u3000\u3000\u3000\u3000魔法に身を包んだ少女が一人\u3000あなたの家の扉を叩き訪ねます\n\n\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000― Trick or Treat? ―\n\n☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆\n\n◆内容紹介◆\n\n\u3000普段は素っ気ない気だるげな美少女月城ルナは、\n\u3000ハロウィーンの魔力でホンモノの吸血鬼になっていました。\n\u3000あなたは、決して抗えない魅了の魔眼で束縛され、\n\u3000その首に甘い牙の口づけを受け、全身をとろとろにとかされていきます……。\n\n◆ドキドキえっちなセリフがいっぱい◆\n\n「あなたは、もう、吸血鬼の私のチャームに完全にかかってしまいました。\n\u3000どうしてか、胸がドキドキとして……嬉しくなってきました。\n\u3000これは、ご褒美です……どうぞ、欲情をもっとかき立てられてください」\n\n「あむ、吸血鬼になっているためか、あなたの血なら、いくらでも吸えそうなほど、甘く感じます……。\n\u3000ん、ちゅ、ちゅ……。\n\u3000ん、大人しくしていてください……。痛みはほとんどないのに、恥ずかしかったりして、動くのは……往生際が悪いというか……」\n\n「んっ……はぁ……見てください、全部、奥まで、入りましたよ……。童貞卒業、おめでとうございます。\n\u3000わかりますよね、嬉しそうにおち〇ちんが、奥のほうでひくひくと震えていますよ。催促するように、ひくひくって、ほら、また……。\n\u3000もっと、キュっとしめてみましょうか……。\n\u3000んっ……完全に私の虜ですね、おち〇ちんどころか、あなたからまで、嬉しそうな悲鳴があがりました」\n\n☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆;:*:;☆\n\nCV \u3000\u3000\u3000:分倍河原シホ\u3000\u3000\u3000\u3000\u3000\u3000\u3000http://shiho.moe.in/v/\nCG \u3000\u3000\u3000:皐月みすず\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000http://satukinchi.xxxxxxxx.jp/\nBGM :フリー音楽素材こんとどぅふぇ\u3000http://conte-de-fees.com/\n\n企画 \u3000\u3000:クッキーボイス\n      \n\n    \n\n            \n  \n\n\n              キャラクター紹介\n    \n    \n          \n        \n          \n                        \n          \n            『わたしの事が知りたいなんて、珍しい人ですね……』\n\n\n          \n        \n      \n\n\n    \n\n            \n  \n\n\n              まじこス『吸血鬼（ヴァンパイア）※特注品』\u3000取り扱い説明書\n    \n    \n          \n        \n          \n                        \n          \n            ■効果……飛行・性感倍増・チャーム\n■呪い……吸血衝動・魔眼による絶対支配・欲望倍加\n\n-お菓子をあげないとこんなに危険！-\nお菓子をもらえなかった場合、彼女は吸血鬼としての性質に目覚めてしまいます。\n抑えがたい吸血衝動（吸われた際にすさまじい快楽を伴います）に加え、\n嗜虐欲支配欲独占欲なども倍加してしまうでしょう。\n\nこの状態で発動する魔眼は絶対的な力を持ちます。\n彼女の虜になり、蕩けてしまいそうな快楽の中で血と精を吸われ続けたい男性の方以外は、\n必ず、お菓子を多量に用意してから、このコスチュームを着た彼女とお過ごし下さい。\n\n※命を取られる心配はありませんのでご安心を！\n          \n        \n      \n\n\n    \n\n            \n  \n\n\n              トラックリスト\n    \n    \n          \n        1. WELCOME\u3000TO\u3000HALLOWEEN\n『ハロウィンの招待状』\u3000約1分\u3000※BGMの有無選択可能\n\n2. 魅了吸血お漏らし\n『ヒロインの来訪、魅了束縛でのイタズラ』\u3000約18分\n\n3. フェラチオきば愛情\n『精液を摂取する、吸血鬼』\t約16分\n\n4. あなたもう゛ぁんぷ\n『童貞卒業、牙で噛み合い』\t約15分\n\n5. 突発ラジオ\n『ラブラブ朝のグッドモーニング放送局』\t約6分",
	}
	testParseWork(t, c, "work", want)
}

func TestParseWorkAnnounce(t *testing.T) {
	t.Parallel()
	c := "RJ275695"
	want := &Work{
		Code:        codes.RJCode(c),
		Title:       "貞操帯所有者のための強制ED化調教",
		Circle:      "Chastity Fancier(性的禁欲愛好家)",
		Series:      "キョウカ様による調教♪",
		Seiyuu:      []string{"琴音有波(紅月ことね)"},
		WorkFormats: []string{"ボイス・ASMR"},
		Description: "☆★☆★☆★☆★☆★☆★☆★☆★\n\n『本作品のテーマ』\n本作品は、「貞操帯」の中におちんちんを閉じ込め、勃起できない状態の中、\nケツマンコに入れたエネマグラで嫌になるほど、「メスイキ」して貰う変態マゾ向けの音声作品です♪\n\n本調教は、おちんちんを「貞操帯」の中に閉じ込め、\n興奮しても気持ちよくなってもピクリとも勃起しない\nED(勃起不全)…ダメちんちんに改造する事をテーマに制作しています。\n\nキョウカ様に全てを委ね、貴方のおちんちん…使い物にならない「ダメちんちん」にしてみませんか?\n(本作単体でも楽しめる内容です♪)\n\n☆★☆★☆★☆★☆★☆★☆★☆★\n\n本日は、CLUB\u3000ドミナンスへようこそいらっしゃいました。\n今宵は宝城\u3000キョウカ\u3000(ホウジョウ\u3000キョウカ)をご指名くださり、誠にありがとうございます。\n\n当店は女性に責められることが好き、もしくは女性に笑われることが\n大好きな変態マゾさんのための会員制高級クラブです。\n当店のミストレスはどの方もドSな方ばかりで、\n調教内容もたいへん厳しいものとなっております。\n中途半端な気持ちで当店ご利用する事は、おやめください。\n\n本日、お客様にお受け頂く調教は「強制ED化コース」となっております。\n\nお客様の「おちんちん」は、「貞操帯」と「メスイキ」により「男性としての機能」を失ってしまいますので、\nあらかじめ覚悟の上、当店をご利用ください♪\n\nこのコースは\n・女性の命令で、最高に変態で歪んだ性体験をしてみたい・・・。\n・おちんちんをダメにしたい・・・。役立たずのED(勃起不全)おちんぽにして欲しい・・・。\n・貞操帯に勃起を阻まれたい・・・。男性としての機能を奪って欲しい・・・。\n・後戻りできない絶望の中で「メスイキ」したい・・・。「メスイキ」に溺れたい・・・。\nそのような方のために設けられたコースです♪\n\n☆★☆★☆★☆★☆★☆★☆★☆★\n\n\n・1_注意事項\n『clubドミナンスを利用する際の注意事項です♪』\n\n・2_導入\n『へぇ～ED化調教に興味があるんだぁ～♪くすっ…いいわよ♪\n\u3000あたしが責任を持って貴方のおちんちんをダメにしてあげる♪\n\u3000今日もまた一歩…「メス」に堕ちてみましょうか♪』\n\n・3_貞操帯装着♪(※貞操帯&鍵を使用)\n『少し待っていてあげるから「貞操帯」を嵌めてきなさい♪\n\u3000ふふ♪最後は「カチッ」って鍵を掛けてあたしにおちんちんを捧げるの…\n\u3000くすっ♪ねぇ…その「鍵」…私に預けてみない?』\n\n・4_エネマグラ挿入♪\n『くすっ♪なぁ～に?このエッチなお尻の穴…。\n\u3000早くエネマグラ入れて欲しくて「パクパク」お口開けてる♪\n\u3000ほら…ケツマンコでエネマグラ「ごっくん♪」って咥え込みなさい…。』\n\n・5_貞操帯の中でのおちんちん勃起♪\n『くすっ♪エネマグラ「キュッキュッ♪」って締め付けて、感じてるとこ悪いけど…。\n\u3000男の子に戻る時間よ?ほら、貞操帯越しにおちんちんシコシコしなさい♪\n\u3000あはっ♪おちんちん小さい檻の中でパンパンに膨らんで苦しそう～♪\n\u3000ほら、勃起させちゃダ~メ♪』\n\n・6_乳首責め&強制ED化♪\n『ふふ♪「訓練」しよっか?気持ちよくなっても興奮しても勃起しない訓練…。\n\u3000ほら、ぷっくり膨らんだそのメス乳首、優しくクリクリ転がしてあげなさい\n\u3000くすっ♪男の子と女の子の狭間で悶えて苦しそう♪\n\u3000ほら、体に勃起する事は悪い事、ダメな事なんだって教え込みなさい♪』\n\n・7_わずかなご褒美…メスイキ♪\n『特別にご褒美をアゲル♪ほら、もう頑張らなくていいよ?\n\u3000快楽に負けてもいいの…「あんっあんっ」って喘ぎながらメスイキしちゃいなさい♪\n\u3000おちんちんの事…忘れちゃえ♪』\n\n・8_妄想&メスイキの取り上げちゃう♪\n『ふふ♪あぁ～あ…男の子が絶対しちゃいけない顔してる…。\n\u3000だいぶいい感じに仕上がってきたみたいね。\n\u3000そろそろあたしの家に招待して飼育を始めてもよさそう…。\n\u3000くすっ♪あたしがいいというまで、そこで悶え続けてなさい♪』\n\n・9_勃起誘発&メスイキ寸止め♪\n『ほら耐えて…勃起させちゃダメ♪【オアズケ】\n\u3000おちんちんが反応しちゃう間は、メスイキさせてあげない♪\n\u3000勃起と苦痛を繰り返しておちんちん「ダメ」にしましょうね♪』\n\n・10_メスイキ条件\n『ふふ♪メスイキしない?メスに堕ちたい?メスマゾになりたい?\n\u3000な～らぁ～…あたしに\u3000【そ・れ】\u3000頂戴♪\u3000絶対なくなさいから♪\n\u3000(【そ・れ】については、本編をご確認ください)』\n\n\n《射精しないver》\n・11_メスイキ選択&ご褒美ドライオーガズム♪\n『ふふ♪偉いわね～♪メスイキを選ぶの…\n\u3000じゃぁ～ご褒美にとびっきりのメスイキを御馳走してア・ゲ・ル♪\n\u3000さぁ、頭の中真っ白して淫らにアクメを繰り返しなさい♪ほら!狂え!!』\n\n・12_ラストスパート♪ご褒美連続絶頂♪\n『ほらほら♪頑張って～♪\u3000ゼロ♪\u3000ゼロ♪\u3000ゼロ♪\u3000\n\u3000あははっ♪貴方の意志に関係なく体があたしの指示で絶頂する♪\n\u3000くすっ♪もう逃がさない…もう逃げられない…。\n\u3000いつまでも気持ちいい…どこまでも気持ちいい…。\n\u3000ほら情けない声絞り出しながら、イケ♪イキ続けろ!!』\n\n\n《射精するver》\n・11_a射精選択&『貞操帯内射精(Orgasm in Chastity Cage)』にチャレンジ♪(※電マを使用)\n『そう…まだ射精に未練があるの…。仕方ないわね…。\n\u3000くすっ♪で・も～♪射精するからって【貞操帯】は外さないわよ?\n\u3000今日は「その中」で射精してもらうから♪\n\u3000(どんなオナニーをさせられるのかは、本編をご確認ください)』\n\n\n総再生時間:約2時間(予定)\n\n\n【追加配布予定】\n《キョウカ様の接客マナー指導》\n・EX_1接客マナー指導(※床置きディルドーを使用)\n『ふふ♪今日は貴方に接客マナーを教えてアゲル♪\n\u3000お客さんを喜ばせる方法…しっかり覚えなさい♪』\n\n・EX_2ご挨拶と騎乗位セックス\n『ほら♪セックスの練習よ?おちんぽ様の上に跨って\n\u3000嫌らしく腰を振りなさい♪は～い、1212♪\n\u3000あはは♪上手い上手い♪セックス上手ね～♪』\n\n・EX_3媚び媚びメスイキ♪\n『体ビクビク痙攣させて、ケツマンコ締め付けてイキなさい♪\n\u3000くすっ♪ほ～ら…勝手に休憩しない♪おちんぽ様気持ちよくして?\n\u3000それが貴方のこれからの「お仕事」でしょ?あはは♪』\n\n☆★☆★☆★☆★☆★☆★☆★☆★\n☆★☆★☆★☆★☆★☆★☆★☆★\n\n【音声作品を視聴する時に用意するもの】\n\n・貞操帯&鍵\n(特に指定はありませんが、一部貞操帯越しのシコシコ指示があります。\n\u3000貞操帯がない方は、妄想でお楽しみ下さい。)\n\n・エネマグラ&ローション等\n(特に指定はありません。前立腺を刺激できる形状のもの)\n\n【《射精するver》で使用】\n・電気マッサージ器\n(特に指定はありません。ブルブル振動するもの)\n\n【《キョウカ様の接客マナー指導EX_1～3》で使用】\n・床置きタイプのディルドー\n(特に指定はありませんが、吸盤タイプがいいと思います。)\n\n☆★☆★☆★☆★☆★☆★☆★☆★\n☆★☆★☆★☆★☆★☆★☆★☆★\n■出演(CV)\n琴音有波様(紅月ことね様)\nhttp://www.stcat.com/~vgb/\n\n■イラスト\ndoskoinpo様\nhttp://doskoinpo.blog133.fc2.com/\n\n■台本\nChastity\u3000Fancier(性的禁欲愛好家)\nhttp://b.dlsite.net/RG35984/\nhttps://ci-en.dlsite.com/creator/302",
	}
	testParseWork(t, c, "announce", want)
}

func testParseWork(t *testing.T, rjcode string, p string, want *Work) {
	c := codes.RJCode(rjcode)
	f, err := os.Open(testdataPath(p, c))
	if err != nil {
		t.Fatalf("Error opening test file: %s", err)
	}
	defer f.Close()
	got, err := parseWork(codes.RJCode(c), f)
	if err != nil {
		t.Fatalf("Error parsing work: %s", err)
	}
	if got.Code != codes.RJCode(c) {
		t.Errorf("Expected Code %#v, got %#v", c, got.Code)
	}
	if want.Title != got.Title {
		t.Errorf("Expected Title %#v, got %#v", want.Title, got.Title)
	}
	if want.Circle != got.Circle {
		t.Errorf("Expected Circle %#v, got %#v", want.Circle, got.Circle)
	}
	if want.Series != got.Series {
		t.Errorf("Expected Series %#v, got %#v", want.Series, got.Series)
	}
	if !reflect.DeepEqual(want.Seiyuu, got.Seiyuu) {
		t.Errorf("Expected Seiyuu %#v, got %#v", want.Seiyuu, got.Seiyuu)
	}
	if !reflect.DeepEqual(want.WorkFormats, got.WorkFormats) {
		t.Errorf("Expected WorkFormats %#v, got %#v", want.WorkFormats, got.WorkFormats)
	}
	if diff := cmp.Diff(want.Description, got.Description); diff != "" {
		t.Errorf("Description mismatch (-want +got):\n%s", diff)
		t.Logf("Got Description %#v", got.Description)
	}
}

func TestParseWorkGame(t *testing.T) {
	t.Parallel()
	c := "RJ265946"
	want := &Work{
		Code:        codes.RJCode(c),
		Title:       "サキュバスアカデミア",
		Circle:      "SQDT",
		Series:      "サキュバスクエスト",
		WorkFormats: []string{"ロールプレイング", "音楽あり", "動画あり"},
		Description: "ゲーム概要\n    \n    \n          \n        \n                          \n                \n                                            \n                                    \n                                \n                  ◆ストーリー\n\nあなたは放課後、幼なじみの少女が同級生とまじわっているのを目撃する。\n彼女は男を誘惑し精を奪う魔物『夢魔』だった。\n\n次々と正体をあらわす夢魔たちに異世界とまざりゆく学園。\n夢にのみこまれる世界を救う手は一つだけ――あなたが殺されることだ。\n                \n                              \n                          \n                \n                                            \n                                    \n                                \n                  ◆バトルシステム\n\nバトル=SEX=敗北!\n\n「サキュバスに敗けて精を奪われる」シーン自体がバトルになる新感覚RPG!\n\n「命乞い」「なすがまま」「屈服」などのアクションを駆使して最高の敗北を目指そう!\n                \n                              \n                          \n                \n                                            \n                                    \n                                \n                  ◆ゲームの流れ\n\nボスとのバトル後、主人公は必ずエナジーを吸い尽くされて死亡します。\n主人公が死亡すると、能力を引き継いで次の主人公に交代します。\n\n主人公になれるキャラクターが全滅する前に、ダンジョンに潜む5体の夢魔を満足させることがゲームの目的です。\n                \n                              \n                          \n                \n                                            \n                                    \n                                \n                  ◆ギャラリーモード\n\nバトルした夢魔とは『時溜まりの地下室』でいつでも再戦可能です。\n前後のイベントも含めた回想や、名前や呼ばれ方のカスタマイズも可能です。\n\n◆魔物図鑑\n\n『学園名簿』ではメインキャラのプロフィールに加え、モブキャラ『マドロミ』も元ネタの神話伝承を交え詳しく解説しています。\n                \n                              \n                    \n      \n\n    \n\n            \n  \n\n\n        \n    \n          \n        \n                          \n                \n                                            \n                                    \n                                \n                  ◆H動画600点、HCG400点以上使用\n\nすべてのボスバトル(=エッチシーン)はフルアニメーション!\n\n40以上のシチュエーションと多彩な差分でバリエーション豊かに敗北しよう!\n                \n                              \n                          \n                \n                                            \n                                    \n                                \n                  ◆豪華ゲストキャラ\n\n漫画家智弘カイ氏の同人誌「共有地の魔」より「エルフリーデ」\nイラストレーター薄稀氏の同人誌「やさしいサキュバスちゃんと」より「サキュバスちゃん」\nイラストレーターしき氏のオリジナルサキュバス「ソフィア」\n同人ゲーム「もんむす・くえすと!」より「アルマエルマ」\n同人ゲーム「Succubus Rhapsodia」より「フルビュア」\n\n以上の豪華ゲストによるサキュバスが特別出演!\nその魅力と原作にちなんだ技であなたを搾り尽くす!\n                \n                              \n                          \n                \n                                            \n                                    \n                                \n                  ◆MOD\n\nMODシステムによりユーザーがゲームを拡張可能!\nバトルの内容を変更したり、新しい展開を加えたりできます。\n\n現在Ci-enにてイラストレーター薄稀氏のファンアートを使った公式MOD「ファントム本番MOD」、および「ピクシー本番MOD」を公開中です!\n\nダウンロードはこちらから\nhttps://ci-en.dlsite.com/creator/4025/article/492983\n                \n                              \n                    \n      \n\n    \n\n            \n  \n\n\n              キャラクター紹介 1/3\n    \n    \n          \n        \n                          \n                \n                                            \n                                    \n                                \n                  【綾瀬 歩夢(アユム)】第二学年 テニス部所属\n\n男子剣道部員、一ノ瀬青児(セイジ)の幼馴染。セイジとはお互い好意を抱いているが、未だ友達止まり。\nいつも積極的なアユムが好意を打ち明けないでいるのは、何か理由があるという噂も……\n                \n                              \n                          \n                \n                                            \n                                    \n                                \n                  【直江 麻夢(まゆ)】第一学年 陸上部所属\n\n部活に打ち込む陸上女子。感情をあまり表に出さないが、実は勝負好き。男子陸上部のエースに密かな対抗心を抱いている。\n陸上以外に興味がなさそうだが、ずっと我慢していたことが……\n                \n                              \n                          \n                \n                                            \n                                    \n                                \n                  【水樹 夢香理(ユカリ)】第三学年 水泳部所属\n\n多くの後輩に慕われる水泳部部長。その泳ぎは天才的で、どこか人間離れしているとまで言われる。\n学園が異世界とまざりあい、部員たちは部長を探すが……\n                \n                              \n                          \n                \n                                            \n                                    \n                                \n                  【葛本 夢月(むつき)】第三学年 茶道部所属\n\n生徒会長を務める真面目な女子。学園の異変にも動じず、生徒たちに自習を促している。\nある時他の生徒たちと共に忽然と消えた彼女の行き先は……\n                \n                              \n                    \n      \n\n    \n\n            \n  \n\n\n              キャラクター紹介 2/3\n    \n    \n          \n        \n                          \n                \n                                            \n                                    \n                                \n                  【御崎 夢衣(ユイ)】第一学年 オカルト部所属\n\nオカルト好きの女子。その知識を活かし、夢魔と対峙する主人公をサポートしようとしてくれる。\nだが異変を利用して学園を牛耳ろうとするオカルト部部長たちに巻き込まれ……\n                \n                              \n                          \n                \n                                            \n                                    \n                                \n                  【吉野 新菜(ニナ)】第二学年 バレー部所属\n\n影でよからぬことをしていると噂の不良少女。\nいつもぶっきらぼうな彼女だが、夢魔の危機に瀕した男子に優しさを見せることも……?\n                \n                              \n                          \n                \n                                            \n                                    \n                                \n                  【望月 悦子(エツコ)】保健の先生\n\nその色気と奇妙に落ち着く雰囲気で、特に男子生徒から人気の保健の先生。\n学園が夢とまざりあってからは、眠りを奪われた生徒たちをベッドと栄養剤で休ませてくれている。\n生徒想いの優しい先生だが、誰も知らない秘密が……\n                \n                              \n                          \n                \n                                            \n                                    \n                                \n                  【ムネモシュネ】\n\n学園の地下室に召喚された記憶の女神。強い記憶に残った場面を再現できる。特に恐怖の記憶を見るのが趣味。\n死の恐怖を味わった主人公から彼女が取り出した記憶は……\n                \n                              \n                    \n      \n\n    \n\n            \n  \n\n\n              キャラクター紹介 3/3\n    \n    \n          \n        \n                          \n                \n                                            \n                                    \n                                \n                  【プフクス】\n\n夢魔を目撃した主人公の前に現れた謎の存在。主人公に逃れられない死の運命を告げ、死者の記憶と共に寄り添う。\n夢魔と敵対しているようだが、その真意は不明……\n                \n                              \n                          \n                \n                                            \n                                    \n                                \n                  【悪魔商人】\n\nオカルト部員が地獄から呼び出した商魂たくましい悪魔商人。\n独特のこだわりがあり、その場所に馴染むものしか売ってくれないが、学園が狂っていくにつれその品揃えも狂気を帯びてくる。\n                \n                              \n                    \n      \n\n    \n\n            \n  \n\n\n        \n    \n          \n        *************************\nサポート、アップデート、ご意見・ご感想の受付などはユーザーサポートページまで\n◆ユーザーサポート: https://ci-en.dlsite.com/creator/4025/article/437340\n\n最新情報はTwitterとblog(Ci-en)でお知らせしています\n◆Twitter: https://twitter.com/SQDT1\n◆blog: https://ci-en.dlsite.com/creator/4025/\n\nMODのリリース、プレイヤー同士のコミュニケーションの場として公式Discordサーバーを設置しています。\n◆Discord: https://discord.gg/8Q2PkJSJqJ\n*************************\n\n⚠ 注意 ⚠\n稀にグラフィックボードの相性により正常に動作しないことがあります。\n少なくとも起動から最初のバトルまでが正常に行えるか、必ず体験版で動作確認をお願いいたします。\n\n体験版のセーブデータは製品版に引き継げません。",
	}
	testParseWork(t, c, "work", want)
}
