// Code generated by "binpack -name collapseText CollapsibleLists.src.js"; DO NOT EDIT.

package webui

const collapseText = "/*\n\nCollapsibleLists.js\n\nAn object allowing lists to dynamically expand and collapse\n\nCreated by Kate Morley - http://code.iamkate.com/ - and released under the terms\nof the CC0 1.0 Universal legal code:\n\nhttp://creativecommons.org/publicdomain/zero/1.0/legalcode\n\n*/\n\nconst CollapsibleLists = (function(){\n\n  // Makes all lists with the class 'collapsibleList' collapsible. The\n  // parameter is:\n  //\n  // doNotRecurse - true if sub-lists should not be made collapsible\n  function apply(doNotRecurse){\n\n    [].forEach.call(document.getElementsByTagName('ul'), node => {\n\n      if (node.classList.contains('collapsibleList')){\n\n        applyTo(node, true);\n\n        if (!doNotRecurse){\n\n          [].forEach.call(node.getElementsByTagName('ul'), subnode => {\n            subnode.classList.add('collapsibleList')\n          });\n\n        }\n\n      }\n\n    })\n\n  }\n\n  // Makes the specified list collapsible. The parameters are:\n  //\n  // node         - the list element\n  // doNotRecurse - true if sub-lists should not be made collapsible\n  function applyTo(node, doNotRecurse){\n\n    [].forEach.call(node.getElementsByTagName('li'), li => {\n\n      if (!doNotRecurse || node === li.parentNode){\n\n        li.style.userSelect       = 'none';\n        li.style.MozUserSelect    = 'none';\n        li.style.msUserSelect     = 'none';\n        li.style.WebkitUserSelect = 'none';\n\n        li.addEventListener('click', handleClick.bind(null, li));\n\n        //toggle(li);\n\n      }\n\n    });\n\n  }\n\n  // Handles a click. The parameter is:\n  //\n  // node - the node for which clicks are being handled\n  function handleClick(node, e){\n\n    let li = e.target;\n    while (li.nodeName !== 'LI'){\n      li = li.parentNode;\n    }\n\n    if (li === node){\n      toggle(node);\n    }\n\n  }\n\n  // Opens or closes the unordered list elements directly within the\n  // specified node. The parameter is:\n  //\n  // node - the node containing the unordered list elements\n  function toggle(node){\n\n    const open = node.classList.contains('collapsibleListClosed');\n    const uls  = node.getElementsByTagName('ul');\n\n    [].forEach.call(uls, ul => {\n\n      let li = ul;\n      while (li.nodeName !== 'LI'){\n        li = li.parentNode;\n      }\n\n      if (li === node){\n        ul.style.display = (open ? 'block' : 'none');\n      }\n\n    });\n\n    node.classList.remove('collapsibleListOpen');\n    node.classList.remove('collapsibleListClosed');\n\n    if (uls.length > 0){\n      node.classList.add('collapsibleList' + (open ? 'Open' : 'Closed'));\n    }\n\n  }\n\n  return {apply, applyTo};\n\n})();\n"
